
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Mar 06 20:03:11 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_RND_MAIN.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* disabling pc lint warning regarding to constant condition :
   'Constant value Boolean' */
/*lint --e{506} */

/***** Include Files ********/
#include "CRYS.h"
#include "CRYS_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_RND_Acceptance.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"
#include "DX_VOS_Stdio.h"

#if TST_USE_RND_DATA/*In case no test vectors are selected - code disabled*/
/******** Defines *******/
/******** Enums *******/
/******** Typedefs ******/
/******** Global Data *****/
/***** Private function prototype ***/
CRYSError_t CRYS_ATP_TST_RND_Acceptance_ALL_TESTS(void);
/******** Public Functions ****/
void CRYS_ATP_TST_RND_main(void)
{
  DxUint8_t  Var;
  do
   {     
     do
     {
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n\n\n--[ Random Number tests Menu ]---------"));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [1] - RNG initializetion test                                               "));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [2] - ReSeeding ( mixing of additional entropy into the working state) test "));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [3] - Random No reset                                                       "));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [4] - Random with reset                                                     "));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [T] - ALL RND Acceptance tests                                              "));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [Z] - End of tests return to prev menu                                      "));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n----------------------------------------\n\n                                 "));
             GET_NON_WHITE_SPACE_CHAR(Var);
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n Test = %c\n",Var));
             if (Var<='Z')
                      break;
             else
             {
                   ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n Error[%d]  Please select '1'-'XX'\n\n",Var));
             }

      }while(1);


      switch(Var)
      {
        case '1':
#ifdef RND_KAT_TEST_MODE_FOR_VER_21
            CRYS_ATP_TST_PRNG_Acceptance_Instantiation();
#else
          ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n For this test to work please compile ATP with preprocessor definition RND_KAT_TEST_MODE_FOR_VER_21 \n"));
#endif
            break;
        case '2':
#ifdef RND_KAT_TEST_MODE_FOR_VER_21
            CRYS_ATP_TST_PRNG_Acceptance_ReSeeding();
#else
          ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n For this test to work please compile ATP with preprocessor definition RND_KAT_TEST_MODE_FOR_VER_21 \n"));
#endif
          break;
        case '3':
            CRYS_ATP_TST_RND_Acceptance_No_Reset();
            break;
        case '4':
            CRYS_ATP_TST_RND_Acceptance_Reset();
            break;
        case 'T':
            CRYS_ATP_TST_RND_Acceptance_ALL_TESTS ();
            break;
           case 'Z':
                  ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n End of RND tests \n"));
                  break ;
           default:
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n* Error in test selection [%c]\n",Var));
      }
         if(Var =='Z')
         break;
     }while (1);
}

/***************************
 * Function Name:
 *   CRYS_ATP_TST_HASH_Acceptance_ALL_TESTS
 *
 * Inputs:
 *   none
 *
 * Outputs:
 *   CRYSError_t - Function error return
 *
 * Description:
 * This function runs all of the HASH Acceptance tests
 *
 **************************/
CRYSError_t CRYS_ATP_TST_RND_Acceptance_ALL_TESTS(void)
{
    CRYSError_t            TST_Status = TESTPASS ,TST_TestStatus = TESTPASS;
    DxUint8_t              TST_DebugStatus = ATP_EXIT_TEST_AFTER_FAILURE;  


    TST_Status = CRYS_ATP_TST_RND_Acceptance_No_Reset();
    TST_TestStatus = TST_Status + TST_TestStatus;

  if (TST_DebugStatus == NO_DEBUG)
  {
      if (TST_TestStatus != TESTPASS)
          goto EXIT_ON_ERROR;
  }

    TST_Status = CRYS_ATP_TST_RND_Acceptance_Reset();
    TST_TestStatus = TST_Status + TST_TestStatus;

  if (TST_DebugStatus == NO_DEBUG)
  {
      if (TST_TestStatus != TESTPASS)
          goto EXIT_ON_ERROR;
  }
  

      ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n \n**********************\n"));
      ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
      ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*** ALL OF THE RND Acceptance TESTS PASS   :-)         ***\n"));
      ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
      ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));

	  return TST_TestStatus;

EXIT_ON_ERROR:
  {
      ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
      ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!! ONE OR MORE OF THE RND TESTS FAILED !!!!!!!!!!!!!!!!!!!!\n"));
      ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));

	  return DX_FAILURE;
  }
    
}

#endif

